/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.data;

import java.util.concurrent.TimeUnit;

public class DataSourceConfiguration {
    private String username;
    private String password;
    private String driverClassName = "com.mysql.cj.jdbc.Driver";
    private String jdbcUrl;
    private Integer minimumIdle = 3000;
    private Integer maximumPoolSize = 500;
    private Boolean autoCommit = true;
    private long idleTimeout = Long.parseLong("3000");
    private String poolName = "default_1";
    private long maxLifetime = Integer.parseInt(String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
    private long connectionTimeout = 30000L;
    private String key;
    private Boolean isDefault = false;

    public Boolean getDefault() {
        return this.isDefault;
    }

    public DataSourceConfiguration setDefault(Boolean aDefault) {
        this.isDefault = aDefault;
        return this;
    }

    public static DataSourceConfiguration Builder() {
        return new DataSourceConfiguration();
    }

    public DataSourceConfiguration() {
    }

    public DataSourceConfiguration(String username, String password, String driverClassName, String jdbcUrl, Integer minimumIdle, Integer maximumPoolSize, Boolean autoCommit, Long idleTimeout, String poolName, Integer maxLifetime, Integer connectionTimeout, String key) {
        this.username = username;
        this.password = password;
        this.driverClassName = driverClassName;
        this.jdbcUrl = jdbcUrl;
        this.minimumIdle = minimumIdle;
        this.maximumPoolSize = maximumPoolSize;
        this.autoCommit = autoCommit;
        this.idleTimeout = idleTimeout;
        this.poolName = poolName;
        this.maxLifetime = maxLifetime.intValue();
        this.connectionTimeout = connectionTimeout.intValue();
        this.key = key;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public Integer getMinimumIdle() {
        return this.minimumIdle;
    }

    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getKey() {
        return this.key;
    }

    public DataSourceConfiguration setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataSourceConfiguration setPassword(String password) {
        this.password = password;
        return this;
    }

    public DataSourceConfiguration setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public DataSourceConfiguration setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public DataSourceConfiguration setMinimumIdle(Integer minimumIdle) {
        this.minimumIdle = minimumIdle;
        return this;
    }

    public DataSourceConfiguration setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        return this;
    }

    public DataSourceConfiguration setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public DataSourceConfiguration setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public DataSourceConfiguration setPoolName(String poolName) {
        this.poolName = poolName;
        return this;
    }

    public DataSourceConfiguration setMaxLifetime(Integer maxLifetime) {
        this.maxLifetime = maxLifetime.intValue();
        return this;
    }

    public DataSourceConfiguration setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout.intValue();
        return this;
    }

    public DataSourceConfiguration setKey(String key) {
        this.key = key;
        return this;
    }
}

