/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.config;

import cn.xisoil.config.DynamicDataSource;
import cn.xisoil.config.LocalDataSource;
import cn.xisoil.data.DataSourceConfiguration;
import cn.xisoil.data.DataSourceConfigurationTabulation;
import cn.xisoil.exception.RegisterException;
import cn.xisoil.holder.DataSourceHolder;
import cn.xisoil.service.DataSourceRegistrationComponent;
import cn.xisoil.service.TableDDLService;
import cn.xisoil.utils.SpringContextUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring", ignoreUnknownFields=true)
public class InitDataSourceInfo {
    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private DataSourceRegistrationComponent dataSourceRegistrationComponent;
    private DataSourceConfiguration dataSource;
    @Autowired
    private LocalDataSource localDataSource;
    @Autowired
    private DynamicDataSource dynamicDataSource;
    @Autowired
    private TableDDLService tableDDLService;

    public void setDataSource(DataSourceConfiguration dataSource) {
        this.dataSource = dataSource;
    }

    @PostConstruct
    public void init() {
        HikariConfig config = new HikariConfig();
        if (this.dataSource != null) {
            BeanUtils.copyProperties((Object)this.dataSource, (Object)config);
            HikariDataSource hikariDataSource = new HikariDataSource(config);
            this.springContextUtils.registerSingleton("siteMaster", (Object)hikariDataSource);
            this.localDataSource.setDataSourceMap("siteMaster", hikariDataSource);
            this.localDataSource.defaultTableBase("siteMaster");
        }
        DataSourceConfigurationTabulation dataSourceConfigurationTabulation = new DataSourceConfigurationTabulation();
        List dataSourceConfigurationTabulationList = this.springContextUtils.getBeansForType(DataSourceConfigurationTabulation.class);
        dataSourceConfigurationTabulationList.forEach(dataSource -> dataSourceConfigurationTabulation.addDataSourceConfigurationAll(dataSource.getDataSourceConfiguration()));
        if (!dataSourceConfigurationTabulation.isEmpty().booleanValue()) {
            if (dataSourceConfigurationTabulation.RootNodeConflict().booleanValue()) {
                throw new RegisterException("\u6839\u8282\u70b9\u51b2\u7a81\uff0c\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u6839\u8282\u70b9");
            }
            dataSourceConfigurationTabulation.getDataSourceConfiguration().forEach(dataSourceConfiguration -> this.dataSourceRegistrationComponent.registerDataSource((DataSourceConfiguration)dataSourceConfiguration));
        }
        this.dynamicDataSource.setTargetDataSources(this.localDataSource.getDataSourceMap());
        this.dynamicDataSource.afterPropertiesSet();
        DataSourceHolder.setDataSource("siteMaster");
        this.tableDDLService.updateTable();
    }
}

