/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.aop.asp;

import cn.xisoil.config.LocalDataSource;
import cn.xisoil.exception.DataSourceNullPointException;
import cn.xisoil.holder.DataSourceHolder;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public abstract class MultipleSiteAsp {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LocalDataSource localDataSource;

    @Before(value="@annotation(cn.xisoil.aop.MultipleSite)")
    private void before() {
        DataSourceHolder.setDataSource(this.getTableBase());
    }

    @After(value="@annotation(cn.xisoil.aop.MultipleSite)")
    private void after() {
        DataSourceHolder.setDataSource("siteMaster");
    }

    private String getTableBase() {
        if (this.localDataSource.getDataSourceMap().isEmpty()) {
            this.logger.error(" connection pool error ===> \u8fde\u63a5\u6c60\u4e3a\u7a7a");
            throw new DataSourceNullPointException("\u65e0\u53ef\u7528\u94fe\u63a5\u6c60");
        }
        return this.localDataSource.validTableBase(this.tableBase());
    }

    public String tableBase() {
        return this.localDataSource.defaultTableBase();
    }
}

