package cn.xisoil.data;

import java.util.LinkedList;
import java.util.List;

public class DataSourceConfigurationTabulation {

    private List<DataSourceConfiguration>dataSourceConfigurations=new LinkedList<>();


    public  static DataSourceConfigurationTabulation builder(){
        return new DataSourceConfigurationTabulation();
    }


    public DataSourceConfigurationTabulation addDataSourceConfigurationAll(List<DataSourceConfiguration>dataSourceConfigurations){
        this.dataSourceConfigurations.addAll(dataSourceConfigurations);
        return this;
    }


    public DataSourceConfigurationTabulation addDataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration){
        this.dataSourceConfigurations.add(dataSourceConfiguration);
        return this;
    }

    public List<DataSourceConfiguration> getDataSourceConfiguration(){
       return this.dataSourceConfigurations;
    }


    public Boolean isEmpty(){
        return this.dataSourceConfigurations.isEmpty();
    }


    public Boolean RootNodeConflict(){
        return this.dataSourceConfigurations.stream().filter(DataSourceConfiguration::getDefault).count() > 1;//冲突
    }

}
