package cn.xisoil.config;

import cn.xisoil.data.DataSourceConfiguration;
import cn.xisoil.data.DataSourceConfigurationTabulation;
import cn.xisoil.exception.RegisterException;
import cn.xisoil.holder.DataSourceHolder;
import cn.xisoil.service.DataSourceRegistrationComponent;
import cn.xisoil.service.TableDDLService;
import cn.xisoil.utils.SpringContextUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 节点注册方法
 */
@Component
@ConfigurationProperties(prefix = "spring", ignoreUnknownFields = true)
public class InitDataSourceInfo {

    //数据源列表
    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private DataSourceRegistrationComponent dataSourceRegistrationComponent;
    //ConfigurationProperties注入
    private DataSourceConfiguration dataSource;

    public void setDataSource(DataSourceConfiguration dataSource) {
        this.dataSource = dataSource;
    }
    @Autowired
    private LocalDataSource localDataSource;
    @Autowired
    private DynamicDataSource dynamicDataSource;
    @Autowired
    private TableDDLService tableDDLService;


    /**
     * 初始化配置中心的连接池（只能配置一个）
     */
    @PostConstruct
    public void init() {
        HikariConfig config = new HikariConfig();
        if (dataSource != null) {
            BeanUtils.copyProperties(dataSource, config);
            HikariDataSource hikariDataSource = new HikariDataSource(config);
            springContextUtils.registerSingleton("siteMaster", hikariDataSource);//注册 hikar DataSource
            localDataSource.setDataSourceMap("siteMaster", hikariDataSource);
            localDataSource.defaultTableBase("siteMaster");
        }

        DataSourceConfigurationTabulation dataSourceConfigurationTabulation = new DataSourceConfigurationTabulation();
        List<DataSourceConfigurationTabulation> dataSourceConfigurationTabulationList = springContextUtils.getBeansForType(DataSourceConfigurationTabulation.class);
        dataSourceConfigurationTabulationList.forEach(dataSource -> {
            dataSourceConfigurationTabulation.addDataSourceConfigurationAll(dataSource.getDataSourceConfiguration());
        });

        if (!dataSourceConfigurationTabulation.isEmpty()) {
            if (dataSourceConfigurationTabulation.RootNodeConflict()) {
                throw new RegisterException("根节点冲突，只能设置一个根节点");
            } else {
                dataSourceConfigurationTabulation.getDataSourceConfiguration().forEach(dataSourceConfiguration -> {
                    dataSourceRegistrationComponent.registerDataSource(dataSourceConfiguration);
                });
            }
        }
        dynamicDataSource.setTargetDataSources(localDataSource.getDataSourceMap());
        dynamicDataSource.afterPropertiesSet();
        DataSourceHolder.setDataSource("siteMaster");
        tableDDLService.updateTable();
    }
}
