package cn.xisoil.config;


import cn.xisoil.exception.InfoException;
import cn.xisoil.holder.DataSourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import javax.sql.DataSource;

/**
 * 获取本地数据源key
 */
public class DynamicDataSource extends AbstractRoutingDataSource {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private Boolean isInit=true;

    @Override
    protected Object determineCurrentLookupKey() {
        return DataSourceHolder.getDataSource();
    }

    protected DataSource determineTargetDataSource() {
        if (isInit) {
            isInit=false;
            logger.warn("因为选择了动态多数据源模式,初始化时无法确定默认数据源，成功启动后忽略该信息");
            throw new InfoException("因为选择了动态多数据源模式,初始化时无法确定默认数据源，成功启动后忽略该信息");
        } else {
            try{
                return super.determineTargetDataSource();
            }
            catch (Exception e){
                return getResolvedDataSources().get("siteMaster");
            }
        }
    }

}
