package cn.xisoil.config;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.util.HashMap;
import java.util.Map;

/**
 * 注册主库bean
 */
@Configuration
public class DataSourceConfigureBean  {

    @Autowired
    private LocalDataSource localDataSource;


//    禁止使用该方法加载数据源，该方法加载的数据源会默认注册为根数据源，且无法删除
//    @Primary
//    @Bean("aaa")
//    @ConfigurationProperties(prefix = "spring.datasource")
//    public DataSource dataSource() {
//        DataSource dataSource = DataSourceBuilder.create().build();
//        return dataSource;
//    }


    @Bean
    @Primary
    public DynamicDataSource dynamicDataSource(
    ) {
        Map<Object,Object> targetDataSources=new HashMap<Object,Object>();
        DynamicDataSource dynamicDataSource=new DynamicDataSource();
        dynamicDataSource.setTargetDataSources(targetDataSources);
//        dynamicDataSource.setDefaultTargetDataSource(targetDataSources);
        return dynamicDataSource;
    }

}
