package cn.xisoil.aop.asp;

import cn.xisoil.config.LocalDataSource;
import cn.xisoil.exception.DataSourceNullPointException;
import cn.xisoil.holder.DataSourceHolder;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
@Aspect
public abstract class MultipleSiteAsp {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private LocalDataSource localDataSource;

    @Before(value = "@annotation(cn.xisoil.aop.MultipleSite)")
    private void  before() {
        DataSourceHolder.setDataSource(this.getTableBase());
    }

    @After(value = "@annotation(cn.xisoil.aop.MultipleSite)")
    private void  after() {
        DataSourceHolder.setDataSource("siteMaster");
    }

    private   String getTableBase(){
        if (localDataSource.getDataSourceMap().isEmpty()){
            logger.error(" connection pool error ===> 连接池为空");
            throw new DataSourceNullPointException("无可用链接池");
        }
        return localDataSource.validTableBase(tableBase());
    }

    //可重写方法获取节点名称
    public  String tableBase(){
        return localDataSource.defaultTableBase();
    }


}
