/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.config;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import rx.Observer;

@Component
public class LocalDataSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String defaultTableBase;
    public Observer<Map<Object, Object>> observable;
    private Map<Object, Object> dataSourceMap = new HashMap<Object, Object>();

    @PostConstruct
    private void init() {
        this.observable = new Observer<Map<Object, Object>>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(Map<Object, Object> objectObjectMap) {
                if (!objectObjectMap.containsKey(LocalDataSource.this.defaultTableBase)) {
                    LocalDataSource.this.defaultTableBase = LocalDataSource.this.getDataSourceMap().keySet().iterator().next().toString();
                }
            }
        };
    }

    public void defaultTableBase(String loopkey) {
        this.defaultTableBase = loopkey;
    }

    public String defaultTableBase() {
        if (!this.getDataSourceMap().containsKey(this.defaultTableBase)) {
            this.defaultTableBase = this.getDataSourceMap().keySet().iterator().next().toString();
        }
        return this.defaultTableBase;
    }

    public String validTableBase(String key) {
        if (!this.getDataSourceMap().containsKey(key)) {
            key = this.defaultTableBase;
        }
        return key;
    }

    public Map<Object, Object> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setDataSourceMap(Map<Object, Object> dataSourceMap) {
        this.dataSourceMap = dataSourceMap;
    }

    public void setDataSourceMap(Object name, Object dataSource) {
        this.dataSourceMap.put(name, dataSource);
    }

    public void delDataSourceMap(Object name) {
        this.dataSourceMap.remove(name);
        this.observable.onNext(this.getDataSourceMap());
    }
}

