/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.config;

import cn.xisoil.config.DynamicDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"com.vt.*"}, transactionManagerRef="platformTransactionManager", entityManagerFactoryRef="entityManagerFactory")
public class DynamicDataSourceConfig {
    @Autowired
    private DynamicDataSource dynamicDataSource;

    @Primary
    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder builder) {
        return builder.dataSource((DataSource)((Object)this.dynamicDataSource)).packages(new String[]{"com.vt.*"}).build();
    }

    @Bean
    public PlatformTransactionManager platformTransactionManager(EntityManagerFactoryBuilder builder) {
        LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean = this.entityManagerFactory(builder);
        return new JpaTransactionManager(localContainerEntityManagerFactoryBean.getObject());
    }
}

