package cn.xisoil.config;

import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import rx.Observer;

import java.util.HashMap;
import java.util.Map;

/**
 * 将数据源剥离到本地，方便处理
 */
@Component
public class LocalDataSource {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    //虚拟根节点，根节点无效自动选择下一个字节点为最新根节点
    private String defaultTableBase;
    public Observer<Map<Object, Object>> observable;

    @PostConstruct
    private void init() {
         observable = new Observer<Map<Object, Object>>() {
            @Override
            public void onCompleted() {
            }
            @Override
            public void onError(Throwable throwable) {
            }
            @Override
            public void onNext(Map<Object, Object> objectObjectMap) {
                if (!objectObjectMap.containsKey(defaultTableBase)){
                    defaultTableBase=getDataSourceMap().keySet().iterator().next().toString();
                }
            }
        };
    }

    public void defaultTableBase(String loopkey){
        this.defaultTableBase=loopkey;
    }

    //获取根节点
    public String defaultTableBase(){
        if (!getDataSourceMap().containsKey(defaultTableBase)){
            defaultTableBase=getDataSourceMap().keySet().iterator().next().toString();
        }
        return this.defaultTableBase;
    }

    //判断节点是否有效，无效更换
    public String validTableBase(String key){
        if (!getDataSourceMap().containsKey(key)){
            key=defaultTableBase;
        }
        return key;
    }

    public Map<Object, Object> getDataSourceMap() {
        return dataSourceMap;
    }

    public void setDataSourceMap(Map<Object, Object> dataSourceMap) {
        this.dataSourceMap = dataSourceMap;
    }

    public void setDataSourceMap(Object name, Object dataSource) {
        this.dataSourceMap.put(name,dataSource);
    }

    public void delDataSourceMap(Object name) {
        this.dataSourceMap.remove(name);
        observable.onNext(this.getDataSourceMap());
    }

    private Map<Object, Object>dataSourceMap=new HashMap<>();


}
