package cn.xisoil.data;


import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;

@Entity(name = "YueSeoConfig")
@Table(name = "yue_seo_config")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "站长配置")
public class SeoConfig {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    private String domain;

    @CurdModel(value = "百度密钥",editor = false,comparable = true)
    private String baiduKey;

    @CurdModel(value = "自动提交")
    private Boolean autoCommit;

    @CurdModel(value = "cron表达式",type = ObjectColumnType.STRING)
    private String cron;

    @CurdModel(value = "360账号",type = ObjectColumnType.STRING)
    private String account360;

    @CurdModel(value = "360密码",type = ObjectColumnType.STRING)
    private String password360;

    private String accountSogou;

    private String passwordSogou;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getBaiduKey() {
        return baiduKey;
    }

    public void setBaiduKey(String baiduKey) {
        this.baiduKey = baiduKey;
    }

    public Boolean getAutoCommit() {
        return autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getCron() {
        return cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public String getAccount360() {
        return account360;
    }

    public void setAccount360(String account360) {
        this.account360 = account360;
    }

    public String getPassword360() {
        return password360;
    }

    public void setPassword360(String password360) {
        this.password360 = password360;
    }

    public String getAccountSogou() {
        return accountSogou;
    }

    public void setAccountSogou(String accountSogou) {
        this.accountSogou = accountSogou;
    }

    public String getPasswordSogou() {
        return passwordSogou;
    }

    public void setPasswordSogou(String passwordSogou) {
        this.passwordSogou = passwordSogou;
    }
}
