/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.impl;

import cn.xisoil.HttpEntity;
import cn.xisoil.dao.SeoConfigRepository;
import cn.xisoil.data.SeoConfig;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.NormalException;
import cn.xisoil.service.SeoConfigService;
import cn.xisoil.service.SeoHttpService;
import cn.xisoil.utils.TaskTools;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SeoConfigServiceImpl
implements SeoConfigService {
    @Autowired
    private TaskTools taskTools;
    @Autowired
    private SeoConfigRepository seoConfigRepository;
    @Autowired
    private SeoHttpService seoHttpService;

    @Override
    public R<SeoConfig> getSeoConfig() {
        SeoConfig seoConfig = this.seoConfigRepository.findTopByIdIsNotNull().orElse(new SeoConfig());
        return R.builder().success().data((Object)seoConfig).build();
    }

    @Override
    public R<String> setSeoConfig(SeoConfig request) {
        SeoConfig seoConfig = this.seoConfigRepository.findTopByIdIsNotNull().orElse(new SeoConfig());
        BeanUtils.copyProperties((Object)request, (Object)seoConfig);
        this.seoConfigRepository.save(seoConfig);
        if (StringUtils.isNotBlank((CharSequence)request.getCron())) {
            this.taskTools.refreshCron("\u7ad9\u957f\u63a8\u9001", request.getCron());
        }
        return R.builder().success().message("\u4fdd\u5b58\u6210\u529f").build();
    }

    @Override
    public R<String> pushBaidu(String siteUrl) {
        SeoConfig seoConfig = this.seoConfigRepository.findTopByIdIsNotNull().orElse(new SeoConfig());
        Map<String, String> param = Map.of("site", seoConfig.getDomain(), "token", seoConfig.getBaiduKey());
        HttpEntity httpEntity = this.seoHttpService.pushBaidu(param, siteUrl);
        if (httpEntity.getStatus() == 200) {
            return R.builder().success().data((Object)httpEntity.getJsonBody().getString("success")).build();
        }
        throw new NormalException(httpEntity.getMessage());
    }
}

