package cn.xisoil.service.impl;

import cn.xisoil.HttpEntity;
import cn.xisoil.dao.SeoConfigRepository;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.NormalException;
import cn.xisoil.service.SeoHttpService;
import cn.xisoil.utils.TaskTools;
import cn.xisoil.data.SeoConfig;
import cn.xisoil.service.SeoConfigService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class SeoConfigServiceImpl implements SeoConfigService {

    @Autowired
    private TaskTools taskTools;
    @Autowired
    private SeoConfigRepository seoConfigRepository;
    @Autowired
    private SeoHttpService seoHttpService;

    @Override
    public R<SeoConfig> getSeoConfig() {
        SeoConfig seoConfig = seoConfigRepository.findTopByIdIsNotNull().orElse(new SeoConfig());
        return R.<SeoConfig>builder().success().data(seoConfig).build();
    }

    @Override
    public R<String> setSeoConfig(SeoConfig request) {
        SeoConfig seoConfig = seoConfigRepository.findTopByIdIsNotNull().orElse(new SeoConfig());
        BeanUtils.copyProperties(request, seoConfig);
        seoConfigRepository.save(seoConfig);
        if (StringUtils.isNotBlank(request.getCron())) {
            taskTools.refreshCron("站长推送", request.getCron());
        }
        return R.<String>builder().success().message("保存成功").build();
    }

    // 推送百度
    @Override
    public R<String> pushBaidu(String siteUrl) {
        SeoConfig seoConfig = seoConfigRepository.findTopByIdIsNotNull().orElse(new SeoConfig());
        Map<String, String> param = Map.of("site", seoConfig.getDomain(), "token", seoConfig.getBaiduKey());
        HttpEntity httpEntity = seoHttpService.pushBaidu(param,siteUrl);
        if (httpEntity.getStatus() == 200) {
            return R.<String>builder().success().data(httpEntity.getJsonBody().getString("success")).build();
        } else {
            throw new NormalException(httpEntity.getMessage());
        }
    }
}
