package cn.xisoil.controller;


import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.data.SeoConfig;
import cn.xisoil.data.result.R;
import cn.xisoil.dto.SeoUrlRequest;
import cn.xisoil.service.SeoConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.Valid;

@RestController
@RequestMapping("/manage/seo")
public class SeoConfigController implements PermissionCheckAutomation {
    @Override
    public String getUrl() {
        return "/seo/index";
    }

    @Override
    public String getName() {
        return "SEO推送";
    }

    @Override
    public String getParent() {
        return "站长工具";
    }


    @Override
    public boolean auto() {
        return true;
    }

    @Autowired
    private SeoConfigService seoConfigService;

    @GetMapping
    public R<SeoConfig> getSeoConfig(){
        return seoConfigService.getSeoConfig();
    }

    @PutMapping
    public R<String> setSeoConfig(@Valid @RequestBody SeoConfig seoConfig, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return seoConfigService.setSeoConfig(seoConfig);
    }

    @PostMapping("/baidu")
    public R<String> pushBaidu(@Valid @RequestBody SeoUrlRequest yueSeoConfig, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return seoConfigService.pushBaidu(yueSeoConfig.getUrls());
    }

}
