/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.server.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.data.result.R;
import cn.xisoil.server.data.RedisDir;
import cn.xisoil.server.data.RedisInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/server"})
public class RedisController
implements PermissionCheckAutomation {
    @Autowired
    private RedisTemplate<String, String> redisCacheTemplate;

    @GetMapping(value={"/redis/dir"})
    public R<List<RedisDir>> redis() {
        ArrayList dirs = new ArrayList();
        this.redisCacheTemplate.keys((Object)"*").forEach(key -> dirs.add(RedisDir.builder().remark((String)key).dirName((String)key)));
        return R.builder().data(dirs).build();
    }

    @GetMapping(value={"/redis/dir/{dir}"})
    public R<List<Map<String, String>>> key(@PathVariable String dir) {
        Set keys = this.redisCacheTemplate.keys((Object)(dir + "*"));
        ArrayList mapList = new ArrayList();
        keys.forEach(key -> mapList.add(Map.of("value", key)));
        return R.builder().data(mapList).build();
    }

    @GetMapping(value={"/redis/value"})
    public R<RedisInfo> value(@RequestParam String key) {
        String value = (String)this.redisCacheTemplate.opsForValue().get((Object)key);
        RedisInfo redisInfo = new RedisInfo();
        redisInfo.setValue(value);
        redisInfo.setKey(key);
        redisInfo.setExpireTime(this.redisCacheTemplate.getExpire((Object)key));
        return R.builder().data((Object)redisInfo).build();
    }

    @DeleteMapping(value={"/redis/dir/{dir}"})
    public R<Long> delDir(@PathVariable String dir) {
        Set keys = this.redisCacheTemplate.keys((Object)(dir + ":*"));
        Long result = this.redisCacheTemplate.delete((Collection)keys);
        return R.builder().message("\u5220\u9664\u6210\u529f").data((Object)result).build();
    }

    @DeleteMapping(value={"/redis/value"})
    public R<Long> delValue(@RequestParam String key) {
        this.redisCacheTemplate.delete((Object)key);
        return R.builder().message("\u5220\u9664\u6210\u529f").build();
    }

    public String getUrl() {
        return "/server/redis";
    }

    public String getName() {
        return "\u7f13\u5b58\u670d\u52a1";
    }

    public String getParent() {
        return "\u670d\u52a1\u7ba1\u7406";
    }

    public boolean auto() {
        return true;
    }
}

