/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.annotation.intercept;

import cn.xisoil.annotation.IpIntercept;
import cn.xisoil.dao.XisoilDangerousRepository;
import cn.xisoil.data.Dangerous;
import cn.xisoil.data.SecurityBasic;
import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.exception.ErrorPageException;
import cn.xisoil.exception.RefusedException;
import cn.xisoil.utils.interceptor.ModelHandlerInterceptor;
import cn.xisoil.utils.tool.HttpRequestIpUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

@Component
@Aspect
public class IpInterceptor
extends ModelHandlerInterceptor {
    @Autowired
    private HttpRequestIpUtils httpRequestIpUtils;
    @Autowired
    private RedisTemplate<String, Serializable> redisCacheTemplate;
    @Autowired
    private XisoilDangerousRepository yueDangerousRepository;

    public IpInterceptor() {
        super(List.of("/**"), null);
    }

    @Before(value="@annotation(ipIntercept)")
    public void ipCut(JoinPoint point, IpIntercept ipIntercept) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = this.httpRequestIpUtils.getIpAddress(request);
        Serializable serializable = (Serializable)this.redisCacheTemplate.opsForValue().get((Object)("SECURITY:ACCESS:" + ip));
        if (serializable == null) {
            this.redisCacheTemplate.opsForValue().set((Object)("SECURITY:ACCESS:" + ip), (Object)1, (long)ipIntercept.time(), TimeUnit.SECONDS);
        } else {
            int count = (Integer)serializable + 1;
            if (count > ipIntercept.count()) {
                this.saveLog(ip, "\u9891\u7e41\u8bbf\u95ee");
                try {
                    Serializable serializable1 = (Serializable)this.redisCacheTemplate.opsForValue().get((Object)"SECURITY:BASIC");
                    if (serializable1 != null) {
                        SecurityBasic securityBasic = (SecurityBasic)serializable1;
                    }
                }
                catch (Exception exception) {}
            } else {
                this.redisCacheTemplate.opsForValue().set((Object)("SECURITY:ACCESS:" + ip), (Object)count, this.redisCacheTemplate.getExpire((Object)("SECURITY:ACCESS:" + ip), TimeUnit.SECONDS).longValue(), TimeUnit.SECONDS);
            }
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        List<String> ips;
        Serializable serializable = (Serializable)this.redisCacheTemplate.opsForValue().get((Object)"SECURITY:BASIC");
        if (serializable == null) {
            return true;
        }
        String ip = this.httpRequestIpUtils.getIpAddress(request);
        SecurityBasic securityBasic = (SecurityBasic)serializable;
        if (!securityBasic.getSecurity().booleanValue()) {
            return true;
        }
        if (securityBasic.getHotlink().booleanValue()) {
            String referer = request.getHeader("referer");
            String host = request.getServerName();
            if (("POST".equals(request.getMethod()) || "GET".equals(request.getMethod())) && referer != null) {
                URL url = null;
                try {
                    url = new URL(referer);
                }
                catch (MalformedURLException e) {
                    this.saveLog(ip, "\u975e\u6b63\u5e38\u8bbf\u95ee\uff0c\u5730\u5740\u5f02\u5e38");
                    response.setStatus(HTTPCODE.NOTFOUND.getCode().intValue());
                }
                if (!host.equals(url.getHost())) {
                    this.saveLog(ip, "\u9632\u76d7\u94fe\u62e6\u622a\uff0c\u76d7\u94fe\u7f51\u7ad9\uff1a" + referer);
                    response.setStatus(HTTPCODE.NOTFOUND.getCode().intValue());
                    throw new ErrorPageException(Integer.valueOf(401), "\u6d89\u5acc\u975e\u6cd5\u76d7\u94fe");
                }
            }
        }
        if ((ips = Arrays.stream(securityBasic.getRollList().split(",|\uff0c|\n")).toList()).contains(ip)) {
            this.saveLog(ip, "IP\u62c9\u9ed1");
            throw new RefusedException("IP\u62c9\u9ed1");
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    private void saveLog(String ip, String message) {
        Dangerous yueDangerous = new Dangerous();
        yueDangerous.setIp(ip);
        yueDangerous.setRemark(message);
        this.yueDangerousRepository.save(yueDangerous);
    }
}

