package cn.xisoil.server.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.data.result.R;
import cn.xisoil.server.data.RedisInfo;
import cn.xisoil.server.data.RedisDir;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;
import java.util.*;

@RestController
@RequestMapping("/manage/server")
public class RedisController implements PermissionCheckAutomation {

    @Autowired
    private RedisTemplate<String, String> redisCacheTemplate;

    @GetMapping("/redis/dir")
    public R<List<RedisDir>> redis(){
        List<RedisDir>dirs=new ArrayList<>();
        redisCacheTemplate.keys("*").forEach(key->{
            dirs.add(RedisDir.builder().remark(key).dirName(key));
        });
        return R.<List<RedisDir>>builder().data(dirs).build();
    }

    @GetMapping("/redis/dir/{dir}")
    public R<List<Map<String, String>>> key(@PathVariable String dir){
        Set<String> keys = redisCacheTemplate.keys(dir+"*");
        List<Map<String, String>> mapList=new ArrayList<>();
        keys.forEach(key->{
            mapList.add(Map.of("value",key));
        });
        return R.<List<Map<String, String>>>builder().data(mapList).build();
    }

    @GetMapping("/redis/value")
    public R<RedisInfo> value(@RequestParam String key){
        String value = redisCacheTemplate.opsForValue().get(key);
        RedisInfo redisInfo =new RedisInfo();
        redisInfo.setValue(value);
        redisInfo.setKey(key);
        redisInfo.setExpireTime(redisCacheTemplate.getExpire(key));
        return R.<RedisInfo>builder().data(redisInfo).build();
    }

    @DeleteMapping("/redis/dir/{dir}")
    public R<Long> delDir(@PathVariable String dir){
        Set<String> keys = redisCacheTemplate.keys(dir+":*");
        Long result = redisCacheTemplate.delete(keys);
        return R.<Long>builder().message("删除成功").data(result).build();
    }

    @DeleteMapping("/redis/value")
    public R<Long> delValue(@RequestParam String key){
       redisCacheTemplate.delete(key);
        return R.<Long>builder().message("删除成功").build();
    }

    @Override
    public String getUrl() {
        return "/server/redis";
    }

    @Override
    public String getName() {
        return "缓存服务";
    }

    @Override
    public String getParent() {
        return "服务管理";
    }

    @Override
    public boolean auto() {
        return true;
    }

}
