package cn.xisoil.data;


import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;
import java.io.Serializable;

@Entity(name = "YueSecurityBasic")
@Table(name = "yue_security_basic")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "安全配置")
public class SecurityBasic implements Serializable {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "开启防御",type = ObjectColumnType.BOOLEAN)
    @JsonProperty("isSecurity")
    private Boolean isSecurity;

    @CurdModel(value = "防盗链",type = ObjectColumnType.BOOLEAN)
    @JsonProperty("isHotlink")
    private Boolean isHotlink;

    @CurdModel(value = "拦截列表",type = ObjectColumnType.TEXTAREA)
    private String rollList;

    public String getRollList() {
        return rollList==null?"":rollList;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getSecurity() {
        return isSecurity;
    }

    public void setSecurity(Boolean security) {
        isSecurity = security;
    }

    public Boolean getHotlink() {
        return isHotlink;
    }

    public void setHotlink(Boolean hotlink) {
        isHotlink = hotlink;
    }

    public void setRollList(String rollList) {
        this.rollList = rollList;
    }

}
