package cn.xisoil.service.impl;

import cn.xisoil.data.SecurityBasic;
import cn.xisoil.dao.XisoilSecurityBasicRepository;
import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.data.result.R;
import cn.xisoil.service.YueSecurityBasicService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.Serializable;

import static cn.xisoil.asp.intercept.RedisFields.SECURITY_BASIC;


@Service
public class YueSecurityBasicServiceImpl implements YueSecurityBasicService {

    @Autowired
    private XisoilSecurityBasicRepository yueSecurityBasicRepository;

    @Autowired
    private RedisTemplate<String, Serializable> redisCacheTemplate;

    @Override
    public R<SecurityBasic> get() {
        return R.<SecurityBasic>builder().result(HTTPCODE.SUCCESS).data(yueSecurityBasicRepository.findTopByIdIsNotNull().orElse(new SecurityBasic())).build();
    }

    @Override
    public R<String> edit(SecurityBasic edit) {
        SecurityBasic basicData=yueSecurityBasicRepository.findTopByIdIsNotNull().orElse(new SecurityBasic());
        BeanUtils.copyProperties(edit,basicData);
        yueSecurityBasicRepository.save(basicData);
        redisCacheTemplate.opsForValue().set(SECURITY_BASIC,basicData);
        return R.<String>builder().result(HTTPCODE.SUCCESS).build();
    }


}
