package cn.xisoil.data;


import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.model.controller.ModelCurdController;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;
import java.util.Date;

@Entity(name = "YueDangerous")
@Table(name = "Yue_dangerous")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "安全预警",edit = false,add = false)
public class YueDangerous {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "操作IP",type = ObjectColumnType.STRING)
    private String ip;


    @CurdModel(value = "异常时间",type = ObjectColumnType.TIME)
    @CreatedDate
    private Date createTime;

    @CurdModel(value = "描述",type = ObjectColumnType.STRING)
    private String remark;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
