package cn.xisoil.controller;

import cn.xisoil.dao.XisoilSecurityBasicRepository;
import cn.xisoil.data.SecurityBasic;
import cn.xisoil.data.result.R;
import cn.xisoil.model.controller.SingleModelController;
import cn.xisoil.service.YueSecurityBasicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.Valid;

@RestController
@RequestMapping("/manage/security/basic")
public class SecurityBasicController extends SingleModelController<SecurityBasic, XisoilSecurityBasicRepository> {

    @Override
    public String getUrl() {
        return "/security/basic";
    }

    @Override
    public String getName() {
        return "安全配置";
    }

    @Override
    public String getParent() {
        return "安全中心";
    }

    @Override
    public boolean auto() {
        return true;
    }

    @Autowired
    private YueSecurityBasicService yueSecurityBasicService;

    @GetMapping("")
    @Primary
    public R<SecurityBasic> get(){
        return yueSecurityBasicService.get();
    }

    @PutMapping("")
    @Primary
    public R<String> edit(@Valid  @RequestBody SecurityBasic securityBasic, BindingResult result){
        return yueSecurityBasicService.edit(securityBasic);
    }


}
