package cn.xisoil.service.impl;

import cn.xisoil.data.YueSecurityBasic;
import cn.xisoil.dao.XisoilSecurityBasicRepository;
import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.data.result.R;
import cn.xisoil.service.YueSecurityBasicService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.Serializable;


@Service
public class YueSecurityBasicServiceImpl implements YueSecurityBasicService {

    @Autowired
    private XisoilSecurityBasicRepository yueSecurityBasicRepository;

    @Autowired
    private RedisTemplate<String, Serializable> redisCacheTemplate;

    @Override
    public R<YueSecurityBasic> get() {
        return R.<YueSecurityBasic>builder().result(HTTPCODE.SUCCESS).data(yueSecurityBasicRepository.findTopByIdIsNotNull().orElse(new YueSecurityBasic())).build();
    }

    @Override
    public R<String> edit(YueSecurityBasic edit) {
        YueSecurityBasic basicData=yueSecurityBasicRepository.findTopByIdIsNotNull().orElse(new YueSecurityBasic());
        BeanUtils.copyProperties(edit,basicData);
        yueSecurityBasicRepository.save(basicData);
//        redisCacheTemplate.opsForValue().set(SECURITY_BASIC,basicData);
        return R.<String>builder().result(HTTPCODE.SUCCESS).build();
    }


}
