/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.server.interfaces;

import cn.xisoil.server.data.YueRedisDir;
import cn.xisoil.server.interfaces.RedisDirField;
import cn.xisoil.server.interfaces.RedisDirObject;
import cn.xisoil.utils.SpringContextUtils;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisDirKeyUtils {
    @Autowired
    SpringContextUtils yueContextUtils;
    private final List<YueRedisDir> redisDirs = new ArrayList<YueRedisDir>();

    @PostConstruct
    public void init() {
        Map handlerMap = this.yueContextUtils.getBeansWithAnnotation(RedisDirObject.class);
        handlerMap.values().forEach(a -> {
            Field[] fields = a.getClass().getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                Field field = fields[j];
                if (!field.isAnnotationPresent(RedisDirField.class)) continue;
                try {
                    RedisDirField redisDirField = field.getAnnotation(RedisDirField.class);
                    YueRedisDir yueRedisDir = new YueRedisDir();
                    String dirName = field.get("value").toString();
                    if (dirName.endsWith(":")) {
                        dirName = dirName.substring(0, dirName.length() - 1);
                    }
                    yueRedisDir.setDirName(dirName);
                    yueRedisDir.setRemark(redisDirField.value());
                    this.redisDirs.add(yueRedisDir);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
    }

    public List<YueRedisDir> getRedisDirs() {
        return this.redisDirs;
    }
}

