package cn.xisoil.server.controller;
import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.data.result.R;
import cn.xisoil.server.data.YueRedisInfo;
import cn.xisoil.server.interfaces.RedisDirKeyUtils;
import cn.xisoil.server.data.YueRedisDir;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;
import java.util.*;

@RestController
@RequestMapping("/manage/server")
public class YueRedisController implements PermissionCheckAutomation {

    @Autowired
    private RedisTemplate<String, String> redisCacheTemplate;
    @Autowired
    private RedisDirKeyUtils redisDirKeyUtils;

    @GetMapping("/redis/dir")
    public R<List<YueRedisDir>> redis(){
        return R.<List<YueRedisDir>>builder().data(redisDirKeyUtils.getRedisDirs()).build();
    }

    @GetMapping("/redis/dir/{dir}")
    public R<List<Map<String, String>>> key(@PathVariable String dir){
        Set<String> keys = redisCacheTemplate.keys(dir+"*");
        List<Map<String, String>> mapList=new ArrayList<>();
        keys.forEach(key->{
            mapList.add(Map.of("value",key));
        });
        return R.<List<Map<String, String>>>builder().data(mapList).build();
    }

    @GetMapping("/redis/value")
    public R<YueRedisInfo> value(@RequestParam String key){
        String value = redisCacheTemplate.opsForValue().get(key);
        YueRedisInfo yueRedisInfo=new YueRedisInfo();
        yueRedisInfo.setValue(value);
        yueRedisInfo.setKey(key);
        yueRedisInfo.setExpireTime(redisCacheTemplate.getExpire(key));
        return R.<YueRedisInfo>builder().data(yueRedisInfo).build();
    }

    @DeleteMapping("/redis/dir/{dir}")
    public R<Long> delDir(@PathVariable String dir){
        Set<String> keys = redisCacheTemplate.keys(dir+":*");
        Long result = redisCacheTemplate.delete(keys);
        return R.<Long>builder().message("删除成功").data(result).build();
    }


    @DeleteMapping("/redis/value")
    public R<Long> delValue(@RequestParam String key){
       redisCacheTemplate.delete(key);
        return R.<Long>builder().message("删除成功").build();
    }


    @Override
    public String getUrl() {
        return "/server/redis";
    }

    @Override
    public String getName() {
        return "缓存服务";
    }

    @Override
    public String getParent() {
        return "服务管理";
    }

    @Override
    public boolean auto() {
        return true;
    }

}
