/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.wechat;

import cn.xisoil.wechat.AbstractWechatPayUtils;
import cn.xisoil.wechat.WxChatPayObject;
import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.Signer;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.cert.CertificatesManager;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatPayConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AbstractWechatPayUtils abstractWechatPayUtils;
    private PrivateKey privateKey;

    public WxChatPayObject initWechatHttp() throws Exception {
        WxChatPayObject wxChatPayObject = this.abstractWechatPayUtils.getWechatObj();
        this.privateKey = PemUtil.loadPrivateKey((InputStream)new FileInputStream(wxChatPayObject.getPrivateKeyPath()));
        CertificatesManager certificatesManager = CertificatesManager.getInstance();
        certificatesManager.putMerchant(wxChatPayObject.getMchId(), (Credentials)new WechatPay2Credentials(wxChatPayObject.getMchId(), (Signer)new PrivateKeySigner(wxChatPayObject.getSerialNo(), this.privateKey)), wxChatPayObject.getAppV3Secret().getBytes(StandardCharsets.UTF_8));
        Verifier verifier = certificatesManager.getVerifier(wxChatPayObject.getMchId());
        WechatPayHttpClientBuilder builder = WechatPayHttpClientBuilder.create().withMerchant(wxChatPayObject.getMchId(), wxChatPayObject.getSerialNo(), this.privateKey).withValidator((Validator)new WechatPay2Validator(verifier));
        wxChatPayObject.setHttpClient(builder.build());
        return wxChatPayObject;
    }
}

