/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.socket;

import cn.xisoil.socket.ClientCache;
import cn.xisoil.socket.MessageInfo;
import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.OnConnect;
import com.corundumstudio.socketio.annotation.OnDisconnect;
import com.corundumstudio.socketio.annotation.OnEvent;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SocketIOHandler {
    @Resource
    private ClientCache clientCache;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @OnConnect
    public void onConnect(SocketIOClient client) {
        String userId = client.getHandshakeData().getSingleUrlParam("id");
        UUID sessionId = client.getSessionId();
        this.clientCache.saveClient(userId, sessionId, client);
        this.logger.info("id: {}\u8fde\u63a5\u5efa\u7acb\u6210\u529f==>{}", (Object)userId, (Object)sessionId);
    }

    @OnDisconnect
    public void onDisconnect(SocketIOClient client) {
        String userId = client.getHandshakeData().getSingleUrlParam("id");
        UUID sessionId = client.getSessionId();
        this.clientCache.deleteSessionClientByUserId(userId, sessionId);
        this.logger.info("id:{}\u8fde\u63a5\u5173\u95ed\u6210\u529f==>{}", (Object)userId, (Object)sessionId);
    }

    @OnEvent(value="chatevent")
    public void chatEvent(SocketIOClient client, AckRequest ackRequest, MessageInfo message) {
        HashMap<UUID, SocketIOClient> userClient = this.clientCache.getUserClient("1");
        for (Map.Entry<UUID, SocketIOClient> next : userClient.entrySet()) {
            next.getValue().sendEvent("chatevent", new Object[]{message});
        }
        this.logger.info("socketIO\u7ebf\u7a0b\u6d88\u606f==>{}", (Object)message);
    }
}

