/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.socket;

import cn.xisoil.socket.SocketIOHandler;
import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.SocketIOServer;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@org.springframework.context.annotation.Configuration
@ConfigurationProperties(prefix="xisoil.socketio", ignoreUnknownFields=true, ignoreInvalidFields=true)
public class SocketIOConfig
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SocketIOHandler socketIOHandler;
    private String host = "localhost";
    private Integer port = 9092;
    private int bossCount = 1;
    private int workCount = 100;
    private boolean allowCustomRequests = true;
    private int upgradeTimeout = 1000000;
    private int pingTimeout = 6000000;
    private int pingInterval = 25000;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getBossCount() {
        return this.bossCount;
    }

    public void setBossCount(int bossCount) {
        this.bossCount = bossCount;
    }

    public int getWorkCount() {
        return this.workCount;
    }

    public void setWorkCount(int workCount) {
        this.workCount = workCount;
    }

    public boolean isAllowCustomRequests() {
        return this.allowCustomRequests;
    }

    public void setAllowCustomRequests(boolean allowCustomRequests) {
        this.allowCustomRequests = allowCustomRequests;
    }

    public int getUpgradeTimeout() {
        return this.upgradeTimeout;
    }

    public void setUpgradeTimeout(int upgradeTimeout) {
        this.upgradeTimeout = upgradeTimeout;
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(int pingTimeout) {
        this.pingTimeout = pingTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void afterPropertiesSet() throws Exception {
        SocketConfig socketConfig = new SocketConfig();
        socketConfig.setReuseAddress(true);
        socketConfig.setTcpNoDelay(true);
        socketConfig.setSoLinger(0);
        Configuration configuration = new Configuration();
        configuration.setSocketConfig(socketConfig);
        configuration.setHostname(this.host);
        configuration.setPort(this.port.intValue());
        configuration.setBossThreads(this.bossCount);
        configuration.setWorkerThreads(this.workCount);
        configuration.setAllowCustomRequests(this.allowCustomRequests);
        configuration.setUpgradeTimeout(this.upgradeTimeout);
        configuration.setPingTimeout(this.pingTimeout);
        configuration.setPingInterval(this.pingInterval);
        SocketIOServer socketIOServer = new SocketIOServer(configuration);
        socketIOServer.addListeners((Object)this.socketIOHandler);
        socketIOServer.start();
        this.logger.info("\u8fdb\u7a0b\u4fe1\u606f==>socketIO\u8fdb\u7a0b\u5df2\u542f\u52a8");
        this.logger.info("socketIO\u7aef\u53e3==>{}", (Object)this.port);
    }
}

