package cn.xisoil.wechat;

import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.cert.CertificatesManager;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import jakarta.persistence.Access;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;

@Component
public  class WechatPayConfig  {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private AbstractWechatPayUtils abstractWechatPayUtils;

    private PrivateKey privateKey;



    public WxChatPayObject initWechatHttp() throws Exception {

        WxChatPayObject wxChatPayObject=abstractWechatPayUtils.getWechatObj();

        privateKey= PemUtil.loadPrivateKey(new FileInputStream(wxChatPayObject.getPrivateKeyPath())) ;
        // 获取证书管理器实例
        CertificatesManager certificatesManager = CertificatesManager.getInstance();
        certificatesManager.putMerchant(wxChatPayObject.getMchId(), new WechatPay2Credentials(wxChatPayObject.getMchId(),
                new PrivateKeySigner(wxChatPayObject.getSerialNo(), privateKey)), wxChatPayObject.getAppV3Secret().getBytes(StandardCharsets.UTF_8));
        // 从证书管理器中获取verifier
        Verifier verifier = certificatesManager.getVerifier(wxChatPayObject.getMchId());
        WechatPayHttpClientBuilder builder = WechatPayHttpClientBuilder.create()
                .withMerchant(wxChatPayObject.getMchId(), wxChatPayObject.getSerialNo(), privateKey)
                .withValidator(new WechatPay2Validator(verifier));
        // ... 接下来，你仍然可以通过builder设置各种参数，来配置你的HttpClient
        wxChatPayObject.setHttpClient(builder.build());
        return wxChatPayObject;
    }





}
