package cn.xisoil.data;

import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.data.to.StringConverters;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;
import java.util.Date;
import java.util.List;

@Entity(name = "YueNotice")
@Table(name = "Yue_notice")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "通知管理")
public class Notice {


    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "通知对象",type = ObjectColumnType.CHECKBOX,url = "/role/list")
    @Convert(converter = StringConverters.class)
    private List<String> roleIds;

    @CurdModel(value = "添加时间",editor = false,comparable = true)
    @CreatedDate
    private Date createTime;

    @CurdModel(value = "通知标题")
    private String title;

    @CurdModel(value = "通知内容",type = ObjectColumnType.RICHTEXT)
    private String content;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(List<String> roleIds) {
        this.roleIds = roleIds;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }


}
