package cn.xisoil.controller;

import cn.xisoil.dao.NoticeRepository;
import cn.xisoil.data.Notice;
import cn.xisoil.data.result.R;
import cn.xisoil.model.controller.ModelCurdControllerMapping;
import cn.xisoil.service.NoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RequestMapping("/manage/notice")
@RestController
public class CurdNoticeController extends ModelCurdControllerMapping<Notice, NoticeRepository> {

    @Autowired
    private NoticeService noticeService;

    @GetMapping("/user")
    public R<List<Notice>> getList(){
        return noticeService.getNotice();
    }


    @Override
    public String getUrl() {
        return "/notice";
    }

    @Override
    public String getName() {
        return "用户通知";
    }

    @Override
    public String getParent() {
        return "通知管理";
    }
}
