/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.controller;

import cn.xisoil.annotation.auth.IgnoreToken;
import cn.xisoil.data.MavenInfoResult;
import cn.xisoil.data.MavenUpdate;
import cn.xisoil.data.result.R;
import cn.xisoil.service.MavenHttpService;
import cn.xisoil.utils.HttpServletWriteUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/maven"})
@IgnoreToken
public class MavenController
extends HttpServletWriteUtils {
    @Autowired
    private MavenHttpService mavenHttpService;

    @GetMapping(value={"/all"})
    public R<?> getMaven() throws IOException, XmlPullParserException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        String myPom = ResourceUtils.getURL((String)"classpath:").getPath().replace("/target/classes/", "") + "/pom.xml";
        Model model = reader.read((Reader)new FileReader(myPom));
        List<Dependency> version = model.getDependencies().stream().filter(a -> a.getGroupId().equals("cn.xisoil")).toList();
        return R.ok(version);
    }

    @GetMapping(value={"/update/{artifactId}"})
    public R<MavenUpdate> getUpdate(@PathVariable String artifactId) throws IOException, XmlPullParserException {
        Map<String, Object> param = Map.of("_dc", new Date().getTime(), "q", artifactId);
        MavenInfoResult mavenInfoResult = (MavenInfoResult)this.mavenHttpService.getByArtifactId(param).asObject(MavenInfoResult.class);
        MavenInfoResult.DataDTO dataDTO = mavenInfoResult.getData().stream().filter(a -> a.getLatestRelease().equals(a.getVersion())).findFirst().orElse(null);
        MavenXpp3Reader reader = new MavenXpp3Reader();
        String myPom = ResourceUtils.getURL((String)"classpath:").getPath().replace("/target/classes/", "") + "/pom.xml";
        Model model = reader.read((Reader)new FileReader(myPom));
        Dependency version = model.getDependencies().stream().filter(a -> a.getArtifactId().equals(artifactId)).findFirst().get();
        MavenUpdate mavenUpdate = new MavenUpdate();
        mavenUpdate.setDataDTO(dataDTO);
        mavenUpdate.setHasUpdate(!version.getVersion().equals(dataDTO.getLatestRelease()));
        mavenUpdate.setVersion(dataDTO.getVersion());
        return R.ok((Object)mavenUpdate);
    }

    @GetMapping(value={"/version/comparison/{artifactId}"})
    public R<?> getVersionComparison(@PathVariable String artifactId) {
        Map<String, Object> param = Map.of("_dc", new Date().getTime(), "q", artifactId);
        MavenInfoResult mavenInfoResult = (MavenInfoResult)this.mavenHttpService.getByArtifactId(param).asObject(MavenInfoResult.class);
        return R.ok((Object)mavenInfoResult);
    }

    @GetMapping(value={"/download/{artifactId}/{version}"})
    public void download(@PathVariable String artifactId, @PathVariable String version, HttpServletResponse response) throws IOException {
        Map<String, Object> param = Map.of("_dc", new Date().getTime(), "a", artifactId, "v", version);
        String repositoryPath = this.mavenHttpService.getInfo(param).getJsonBody().getJSONObject("data").getString("repositoryPath");
        String downloadpath = "https://s01.oss.sonatype.org/service/local/repositories/releases/content/" + repositoryPath;
        super.writeLineAndFlush("\u4e0b\u8f7d\u4efb\u52a1\u5df2\u63d0\u4ea4");
        super.writeLineAndFlush("\u51c6\u5907\u4e0b\u8f7d\uff1a" + artifactId + "-" + version + ".jar");
        this.down(downloadpath, "resources/", artifactId + ".jar", response);
    }

    private void down(String neturl, String path, String filename, HttpServletResponse response) throws IOException {
        int bytesum = 0;
        int byteread = 0;
        URL url = new URL(neturl);
        URLConnection conn = url.openConnection();
        InputStream inStream = conn.getInputStream();
        FileOutputStream fs = new FileOutputStream(path + "\\" + filename);
        byte[] buffer = new byte[1204];
        while ((byteread = inStream.read(buffer)) != -1) {
            bytesum += byteread;
            fs.write(buffer, 0, byteread);
            super.writeLineAndFlush("\u5df2\u4e0b\u8f7d\uff1a" + byteread + "\u5b57\u8282");
        }
        super.writeLineAndFlush("\u4e0b\u8f7d\u5b8c\u6210\uff1a" + filename);
        inStream.close();
        fs.close();
    }
}

