package cn.xisoil.controller;


import cn.xisoil.annotation.auth.IgnoreToken;
import cn.xisoil.data.MavenInfoResult;
import cn.xisoil.data.MavenUpdate;
import cn.xisoil.data.result.R;
import cn.xisoil.service.MavenHttpService;
import cn.xisoil.utils.HttpServletWriteUtils;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.*;

import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-06-2023/6/9 22:13:11
 **/

@RestController
@RequestMapping("/manage/maven")
@IgnoreToken
public class MavenController extends HttpServletWriteUtils {

    @Autowired
    private MavenHttpService mavenHttpService;

    @GetMapping("/all")
    public R<?> getMaven() throws IOException, XmlPullParserException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        String myPom= ResourceUtils.getURL("classpath:")
                .getPath()
                .replace("/target/classes/","")
                +"/pom.xml";
        Model model = reader.read(new FileReader(myPom));
        List<Dependency >  version = model.getDependencies().stream().filter(a->a.getGroupId().equals("cn.xisoil")).toList();//获取版本号
        return R.ok(version);
    }

    @GetMapping("/update/{artifactId}")
    public R<MavenUpdate>getUpdate(@PathVariable String artifactId) throws IOException, XmlPullParserException {
        Map<String,Object>param=Map.of("_dc",new Date().getTime(),"q",artifactId);
        MavenInfoResult mavenInfoResult=mavenHttpService.getByArtifactId(param).asObject(MavenInfoResult.class);

        MavenInfoResult.DataDTO dataDTO=mavenInfoResult.getData().stream().filter(a->a.getLatestRelease().equals(a.getVersion()))
                .findFirst().orElse(null);

        MavenXpp3Reader reader = new MavenXpp3Reader();
        String myPom= ResourceUtils.getURL("classpath:")
                .getPath()
                .replace("/target/classes/","")
                +"/pom.xml";
        Model model = reader.read(new FileReader(myPom));
        Dependency  version = model.getDependencies().stream().filter(a->a.getArtifactId().equals(artifactId)).findFirst().get();//获取版本号

        MavenUpdate mavenUpdate=new MavenUpdate();
        mavenUpdate.setDataDTO(dataDTO);
        mavenUpdate.setHasUpdate(!version.getVersion().equals(dataDTO.getLatestRelease()));
        mavenUpdate.setVersion(dataDTO.getVersion());
        return R.ok(mavenUpdate);
    }


    @GetMapping("/version/comparison/{artifactId}")
    public R<?>getVersionComparison(@PathVariable String artifactId){
        Map<String,Object>param=Map.of("_dc",new Date().getTime(),"q",artifactId);
        MavenInfoResult mavenInfoResult=mavenHttpService.getByArtifactId(param).asObject(MavenInfoResult.class);;
        return R.ok(mavenInfoResult);
    }


    @GetMapping("/download/{artifactId}/{version}")
    public void download(@PathVariable String artifactId, @PathVariable String version, HttpServletResponse response) throws IOException {
        Map<String,Object>param=Map.of("_dc",new Date().getTime(),"a",artifactId,"v",version);
        String repositoryPath=mavenHttpService.getInfo(param).getJsonBody().getJSONObject("data").getString("repositoryPath");
//        https://s01.oss.sonatype.org/service/local/repositories/releases/content/cn/xisoil/xisoil-core/2.1.6-RELEASE/xisoil-core-2.1.6-RELEASE-javadoc.jar
        String downloadpath = "https://s01.oss.sonatype.org/service/local" +
                "/repositories/releases/content/"+repositoryPath;
        super.writeLineAndFlush("下载任务已提交");
        super.writeLineAndFlush("准备下载："+artifactId+"-"+version+".jar");
        down(downloadpath,"resources/",artifactId+".jar",response);
    }


    private void down(String neturl,String path,String filename, HttpServletResponse response  ) throws IOException {
//                下载网络文件并保存到指定目录
        //下载网络文件
        int bytesum = 0;
        int byteread = 0;
        URL url = new URL(neturl);
        URLConnection conn = url.openConnection();
        InputStream inStream = conn.getInputStream();
        FileOutputStream fs = new FileOutputStream(path + "\\" + filename);

        byte[] buffer = new byte[1204];
        while ((byteread = inStream.read(buffer)) != -1) {
            bytesum += byteread;
            fs.write(buffer, 0, byteread);
            super.writeLineAndFlush("已下载："+byteread+"字节");
        }
        super.writeLineAndFlush("下载完成："+filename);
        inStream.close();
        fs.close();
    }


}
