/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.controller;

import cn.xisoil.annotation.auth.IgnoreToken;
import cn.xisoil.data.MavenInfoResult;
import cn.xisoil.data.result.R;
import cn.xisoil.service.MavenHttpService;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/maven"})
@IgnoreToken
public class MavenController {
    @Autowired
    private MavenHttpService mavenHttpService;

    @GetMapping(value={"/all"})
    public R<?> getMaven() throws IOException, XmlPullParserException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        String myPom = ResourceUtils.getURL((String)"classpath:").getPath().replace("/target/classes/", "") + "/pom.xml";
        Model model = reader.read((Reader)new FileReader(myPom));
        List<Dependency> version = model.getDependencies().stream().filter(a -> a.getGroupId().equals("cn.xisoil")).toList();
        return R.ok(version);
    }

    @GetMapping(value={"/version/comparison/{artifactId}"})
    public R<?> getVersionComparison(@PathVariable String artifactId) {
        Map<String, Object> param = Map.of("_dc", new Date().getTime(), "q", artifactId);
        MavenInfoResult mavenInfoResult = (MavenInfoResult)this.mavenHttpService.getByArtifactId(param).asObject(MavenInfoResult.class);
        return R.ok((Object)mavenInfoResult);
    }

    @GetMapping(value={"/download/{artifactId}/{version}"})
    public R<?> download(@PathVariable String artifactId, @PathVariable String version) {
        Map<String, Object> param = Map.of("_dc", new Date().getTime(), "a", artifactId, "v", version);
        return R.ok((Object)this.mavenHttpService.getInfo(param).getJsonBody().get("data"));
    }
}

