package cn.xisoil.controller;


import cn.xisoil.annotation.auth.IgnoreToken;
import cn.xisoil.data.MavenInfoResult;
import cn.xisoil.data.result.R;
import cn.xisoil.service.MavenHttpService;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.*;

import java.io.*;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-06-2023/6/9 22:13:11
 **/

@RestController
@RequestMapping("/manage/maven")
@IgnoreToken
public class MavenController {

    @Autowired
    private MavenHttpService mavenHttpService;

    @GetMapping("/all")
    public R<?> getMaven() throws IOException, XmlPullParserException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        String myPom= ResourceUtils.getURL("classpath:")
                .getPath()
                .replace("/target/classes/","")
                +"/pom.xml";
        Model model = reader.read(new FileReader(myPom));
        List<Dependency >  version = model.getDependencies().stream().filter(a->a.getGroupId().equals("cn.xisoil")).toList();//获取版本号
        return R.ok(version);
    }

    @GetMapping("/version/comparison/{artifactId}")
    public R<?>getVersionComparison(@PathVariable String artifactId){
        Map<String,Object>param=Map.of("_dc",new Date().getTime(),"q",artifactId);
        MavenInfoResult mavenInfoResult=mavenHttpService.getByArtifactId(param).asObject(MavenInfoResult.class);;
        return R.ok(mavenInfoResult);
    }

    @GetMapping("/download/{artifactId}/{version}")
    public R<?>download(@PathVariable String artifactId, @PathVariable String version){
        Map<String,Object>param=Map.of("_dc",new Date().getTime(),"a",artifactId,"v",version);
//        https://s01.oss.sonatype.org/service/local/repositories/releases/content/cn/xisoil/xisoil-core/2.1.6-RELEASE/xisoil-core-2.1.6-RELEASE-javadoc.jar
        return R.ok(mavenHttpService.getInfo(param).getJsonBody().get("data"));
    }


}
