/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil;

import cn.xisoil.emuns.Method;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HttpEntity {
    private Integer status;
    private String body;
    @JsonIgnore
    private Exception exception;
    private String message;
    @JsonIgnore
    private Map<String, List<String>> headers;
    private String url;
    private Method method;
    private String dataType;

    public static HttpEntity of(String url) {
        return new HttpEntity();
    }

    public HttpEntity() {
    }

    public HttpEntity(String url) {
        this.url = url;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public HttpEntity(Integer status, Exception e) {
        this.status = status;
        this.exception = e;
        this.message = e.getMessage();
    }

    public HttpEntity build(Integer status, String body, String message, Map<String, List<String>> headers) {
        this.status = status;
        this.body = body;
        this.message = message;
        this.headers = headers;
        return this;
    }

    public JSONObject getJsonBody() {
        return JSONObject.parseObject((String)this.body);
    }

    @JsonIgnore
    public Object getBody() {
        return this.body;
    }

    public <T> T asObject(Class<T> tClass) {
        return (T)this.getJsonBody().to(tClass, new JSONReader.Feature[0]);
    }

    public HttpEntity method(Method method) {
        this.method = method;
        return this;
    }

    public HttpEntity dataType(String dataType) {
        this.dataType = dataType;
        return this;
    }
}

