package cn.xisoil;

import cn.xisoil.emuns.DataType;
import cn.xisoil.emuns.Method;
import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-03-2023/3/29 11:05:22
 **/

@JsonInclude(JsonInclude.Include.NON_NULL)
public class HttpEntity {


    public static HttpEntity of(String url){
        return new HttpEntity();
    }

    public HttpEntity() {
    }

    public HttpEntity(String url) {
        this.url=url;
    }

    public Integer getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    @JsonIgnore
    public Map<String, List<String>> getHeaders() {
        return headers;
    }

    public HttpEntity(Integer status, Exception e) {
        this.status=status;
        this.exception=e;
        this.message=e.getMessage();
    }

    public HttpEntity build(Integer status, String body, String message, Map<String, List<String>> headers) {
        this.status = status;
        this.body = body;
        this.message = message;
        this.headers = headers;
        return this;
    }

    private Integer status;

    private String body;

    @JsonIgnore
    private Exception exception;

    private String message;

    @JsonIgnore
    private  Map<String, List<String>>headers;

    public JSONObject getJsonBody(){
        return JSONObject.parseObject(body);
    }

    @JsonIgnore
    public Object getBody(){
        return body;
    }

    public <T> T asObject(Class<T> tClass){
        return  getJsonBody().to(tClass);
    }

    private String url;

    private Method method;

    private String dataType;

    public HttpEntity  method( Method method){
        this.method=method;
        return this;
    }

    public HttpEntity  dataType(String dataType){
        this.dataType=dataType;
        return this;
    }






}
