package cn.xisoil.annotation;

import cn.xisoil.emuns.DataType;
import cn.xisoil.emuns.Method;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Http(type = Method.PUT)
public @interface Put {

    @AliasFor(value = "url",annotation = Http.class)
    String url();

    Header[] headers() default {};

    String body() default "";

    DataType contentType() default DataType.JSON;

}
