/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.tool;

import cn.xisoil.HttpEntity;
import cn.xisoil.emuns.DataType;
import cn.xisoil.emuns.Method;
import cn.xisoil.exception.NormalException;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HttpConnection {
    private URL url = null;
    private HttpURLConnection conn = null;
    private HttpEntity httpEntity;

    public static HttpConnection of(String url) {
        return new HttpConnection(url);
    }

    public static HttpConnection of(String url, Object param) {
        if (param != null) {
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)param));
            StringBuilder stringBuilder = new StringBuilder(url);
            jsonObject.forEach((k, v) -> stringBuilder.append(stringBuilder.toString().contains("?") ? (char)'&' : (char)'?').append((String)k).append("=").append(v));
            return new HttpConnection(stringBuilder.toString());
        }
        return new HttpConnection(url);
    }

    public HttpConnection(String url) {
        try {
            this.url = new URL(url);
            this.httpEntity = HttpEntity.of(url);
            this.conn = (HttpURLConnection)this.url.openConnection();
        }
        catch (Exception e) {
            throw new NormalException(e.getMessage());
        }
    }

    public HttpConnection headers(Map<String, Object> headers) {
        headers.forEach(this::header);
        return this;
    }

    public HttpConnection header(String key, Object value) {
        this.conn.addRequestProperty(key, (String)value);
        return this;
    }

    public HttpConnection header(String header) {
        String[] h = header.split(":");
        if (h.length == 2) {
            this.conn.addRequestProperty(h[0], h[1]);
        }
        return this;
    }

    public HttpConnection contentType(DataType type) {
        this.httpEntity.dataType(type.getType());
        this.conn.setRequestProperty("Content-Type", type.getType());
        return this;
    }

    public HttpConnection contentType(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            this.httpEntity.dataType(type);
            this.conn.setRequestProperty("Content-Type", type);
        }
        return this;
    }

    public HttpEntity get() {
        this.httpEntity.method(Method.GET);
        try {
            this.conn.setRequestMethod(String.valueOf((Object)Method.GET));
            this.conn.setConnectTimeout(3000);
            this.conn.setReadTimeout(3000);
            this.conn.connect();
            return this.build();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    public HttpEntity delete() {
        this.httpEntity.method(Method.DELETE);
        try {
            this.conn.setRequestMethod(String.valueOf((Object)Method.DELETE));
            this.conn.setConnectTimeout(3000);
            this.conn.setReadTimeout(3000);
            this.conn.connect();
            return this.build();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    public HttpEntity put(Object body) {
        this.httpEntity.method(Method.PUT);
        try {
            if (body != null) {
                this.conn.setRequestMethod(String.valueOf((Object)Method.PUT));
                return this.body(body);
            }
            return this.put();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    public HttpEntity post(Object body) {
        this.httpEntity.method(Method.POST);
        try {
            if (body != null) {
                this.conn.setRequestMethod(String.valueOf((Object)Method.POST));
                return this.body(body);
            }
            return this.post();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    public HttpEntity patch(Object body) {
        this.httpEntity.method(Method.PATCH);
        try {
            if (body != null) {
                this.conn.setRequestMethod(String.valueOf((Object)Method.PATCH));
                return this.body(body);
            }
            return this.patch();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    private HttpEntity post() {
        try {
            this.conn.setRequestMethod(String.valueOf((Object)Method.POST));
            this.conn.setConnectTimeout(3000);
            this.conn.setReadTimeout(3000);
            this.conn.connect();
            return this.build();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    private HttpEntity put() {
        try {
            this.conn.setRequestMethod(String.valueOf((Object)Method.PUT));
            this.conn.setConnectTimeout(3000);
            this.conn.setReadTimeout(3000);
            this.conn.connect();
            return this.build();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    private HttpEntity body(Object body) throws IOException {
        this.conn.setConnectTimeout(3000);
        this.conn.setReadTimeout(3000);
        this.conn.setDoOutput(true);
        DataOutputStream dos = new DataOutputStream(this.conn.getOutputStream());
        dos.writeBytes(HttpConnection.isBaseType(body) ? (String)body : JSONObject.toJSONString((Object)body, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        dos.flush();
        dos.close();
        return this.build();
    }

    private HttpEntity patch() {
        try {
            this.conn.setRequestMethod(String.valueOf((Object)Method.PATCH));
            this.conn.setConnectTimeout(3000);
            this.conn.setReadTimeout(3000);
            this.conn.connect();
            return this.build();
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    private HttpEntity build() {
        try {
            InputStream is = this.conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
            }
            br.close();
            is.close();
            this.conn.disconnect();
            return this.httpEntity.build(this.conn.getResponseCode(), sb.toString(), "\u8bf7\u6c42\u6210\u529f", this.conn.getHeaderFields());
        }
        catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    private static boolean isBaseType(Object obj) {
        return obj instanceof Integer || obj instanceof Byte || obj instanceof Long || obj instanceof Double || obj instanceof Float || obj instanceof Character || obj instanceof Short || obj instanceof Boolean || obj instanceof String;
    }
}

