/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.config;

import cn.xisoil.annotation.HttpService;
import cn.xisoil.interceptors.MethodInterceptor;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
@Import(value={HttpServiceScannerConfig.class})
public class HttpServiceScannerConfig
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware,
EnvironmentAware,
BeanFactoryAware {
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private Environment environment;
    private static DefaultListableBeanFactory listableBeanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        listableBeanFactory.setAllowBeanDefinitionOverriding(true);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.logPackageScan(importingClassMetadata);
        this.registerSections(importingClassMetadata, registry);
    }

    private void logPackageScan(AnnotationMetadata metadata) {
        Map defaultAttrs = metadata.getAnnotationAttributes(SpringBootApplication.class.getName(), true);
        if (defaultAttrs == null || defaultAttrs.size() > 0) {
            // empty if block
        }
    }

    public void registerSections(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        Map attrs = metadata.getAnnotationAttributes(SpringBootApplication.class.getName());
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(HttpService.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        Set<String> basePackages = this.getBasePackages(metadata);
        for (String basePackage : basePackages) {
            LinkedHashSet<ScannedGenericBeanDefinition> candidates = new LinkedHashSet<ScannedGenericBeanDefinition>();
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            try {
                basePackage = basePackage.replace(".", "/");
                Resource[] resources = resourcePatternResolver.getResources("classpath*:" + basePackage + "/**/*.class");
                SimpleMetadataReaderFactory metadata1 = new SimpleMetadataReaderFactory();
                for (Resource resource : resources) {
                    MetadataReader metadataReader = metadata1.getMetadataReader(resource);
                    ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
                    sbd.setResource(resource);
                    sbd.setSource((Object)resource);
                    candidates.add(sbd);
                }
                for (BeanDefinition beanDefinition : candidates) {
                    String classname = beanDefinition.getBeanClassName();
                    HttpService s = Class.forName(classname).getAnnotation(HttpService.class);
                    if (s == null) continue;
                    MethodInterceptor proxy = new MethodInterceptor();
                    Object proxyImp = proxy.getProxy(Class.forName(classname));
                    System.out.println(proxyImp.getClass().getName());
                    listableBeanFactory.registerSingleton(proxyImp.getClass().getName(), proxyImp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (beanDefinition.getMetadata().isIndependent()) {
                    if (beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().getInterfaceNames().length == 1 && Annotation.class.getName().equals(beanDefinition.getMetadata().getInterfaceNames()[0])) {
                        try {
                            Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)HttpServiceScannerConfig.this.classLoader);
                            return !target.isAnnotation();
                        }
                        catch (Exception ex) {
                            this.logger.error((Object)("Could not load target class: " + beanDefinition.getMetadata().getClassName()), (Throwable)ex);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        HashSet<String> basePackages = new HashSet<String>();
        Map objectMap = listableBeanFactory.getBeansWithAnnotation(SpringBootApplication.class);
        objectMap.forEach((k, v) -> {
            SpringBootApplication springBootApplication = v.getClass().getAnnotation(SpringBootApplication.class);
            for (String pkg : springBootApplication.scanBasePackages()) {
                if (pkg == null || "".equals(pkg)) continue;
                basePackages.add(pkg);
            }
            if (basePackages.isEmpty()) {
                basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
            }
        });
        basePackages.add("cn.xisoil.*");
        return basePackages;
    }
}

