package cn.xisoil.tool;

import cn.xisoil.HttpEntity;
import cn.xisoil.emuns.DataType;
import cn.xisoil.emuns.Method;
import cn.xisoil.exception.NormalException;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import org.apache.commons.lang3.StringUtils;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * @Description HTTP请求方法
 * @Author Vien
 * @CreateTime 2023-03-2023/3/29 10:18:57
 **/
public class HttpConnection {

    private URL url = null;
    private HttpURLConnection conn = null;

    private HttpEntity httpEntity;


    public static HttpConnection of(String url) {
        return new HttpConnection(url);
    }

    public static HttpConnection of(String url,Object param) {
        if (param!=null){
            JSONObject jsonObject= JSON.parseObject(JSON.toJSONString(param));
            StringBuilder stringBuilder=new StringBuilder(url);
            jsonObject.forEach((k,v)->{
                stringBuilder.append(stringBuilder.toString().contains("?")?'&':'?').append(k).append("=").append(v);
            });
            return new HttpConnection(stringBuilder.toString());
        }
        return new HttpConnection(url);
    }

    public HttpConnection(String url) {
        try {
            this.url = new URL(url);
            httpEntity=HttpEntity.of(url);
            conn = (HttpURLConnection) this.url.openConnection();
        } catch (Exception e) {
                throw new NormalException(e.getMessage());
        }
    }


    public HttpConnection headers(Map<String, Object> headers) {
        headers.forEach(this::header);
        return this;
    }

    public HttpConnection header(String key, Object value) {
        conn.addRequestProperty(key, (String) value);
        return this;
    }

    public HttpConnection header(String header) {
        String[] h=header.split(":");
        if (h.length==2){
            conn.addRequestProperty(h[0], h[1]);
        }
        return this;
    }

    public HttpConnection contentType(DataType type) {
        httpEntity.dataType(type.getType());
        conn.setRequestProperty("Content-Type", type.getType());
        return this;
    }

    public HttpConnection contentType(String type) {
        if (StringUtils.isNotBlank(type)) {
            httpEntity.dataType(type);
            conn.setRequestProperty("Content-Type", type);
        }
        return this;
    }


    public HttpEntity get() {
        httpEntity.method(Method.GET);
        try {
            conn.setRequestMethod(String.valueOf(Method.GET));
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            return build();
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }


    public HttpEntity delete() {
        httpEntity.method(Method.DELETE);
        try {
            conn.setRequestMethod(String.valueOf(Method.DELETE));
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            return build();
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }


    public HttpEntity put(Object body) {
        httpEntity.method(Method.PUT);
        try {
            if (body != null) {
                conn.setRequestMethod(String.valueOf(Method.PUT));
                return body(body);
            }
            else {
                return put();
            }
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }


    public HttpEntity post(Object body) {
        httpEntity.method(Method.POST);
        try {
            if (body != null) {
                conn.setRequestMethod(String.valueOf(Method.POST));
                return body(body);
            }
            else {
                return post();
            }
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    public HttpEntity patch(Object body) {
        httpEntity.method(Method.PATCH);
        try {
            if (body != null) {
                conn.setRequestMethod(String.valueOf(Method.PATCH));
                return body(body);
            }
            else {
                return patch();
            }
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }


    private HttpEntity post() {
        try {
            conn.setRequestMethod(String.valueOf(Method.POST));
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            return build();
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }

    private HttpEntity put() {
        try {
            conn.setRequestMethod(String.valueOf(Method.PUT));
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            return build();
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }


    private HttpEntity body(Object body) throws IOException {
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(3000);
        conn.setDoOutput(true);
        DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
        dos.writeBytes( isBaseType(body) ? (String) body : JSONObject.toJSONString(body));
        dos.flush();
        dos.close();
        return build();
    }


    private HttpEntity patch() {
        try {
            conn.setRequestMethod(String.valueOf(Method.PATCH));
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            return build();
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }
    private HttpEntity build() {
        try {
            InputStream is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
            }
            br.close();
            is.close();
            conn.disconnect();
            return httpEntity.build(conn.getResponseCode(), sb.toString(), "请求成功", conn.getHeaderFields());
        } catch (Exception e) {
            return new HttpEntity(500, e);
        }
    }
    //判断一个变量是否属于基本类型或封装类
    private static boolean isBaseType(Object obj) {
        return obj instanceof Integer
                || obj instanceof Byte
                || obj instanceof Long
                || obj instanceof Double
                || obj instanceof Float
                || obj instanceof Character
                || obj instanceof Short
                || obj instanceof Boolean
                || obj instanceof String;
    }

}
