package cn.xisoil.annotation;

import cn.xisoil.emuns.DataType;
import cn.xisoil.emuns.Method;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Http(type = Method.PATCH)
public @interface Patch {


    @AliasFor(value = "url",annotation = Http.class)
    String url();

    @AliasFor(value = "headers",annotation = Http.class)
    Header[] headers() default {};

    DataType contentType() default DataType.JSON;

    String body() default "";

}
