package cn.xisoil.interceptors;

import cn.xisoil.HttpEntity;
import cn.xisoil.annotation.*;
import cn.xisoil.tool.HttpConnection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.annotation.AnnotatedElementUtils;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.*;

/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-03-2023/3/29 08:43:13
 **/
public class MethodInterceptor implements org.springframework.cglib.proxy.MethodInterceptor {

    private Enhancer enhancer = new Enhancer();

    public Object getProxy(Class clazz) {
        enhancer.setSuperclass(clazz);
        enhancer.setCallback(this);
        return enhancer.create();
    }

    //实现MethodInterceptor接口方法
    public Object intercept(Object obj, Method method, Object[] args,
                            MethodProxy proxy) throws Throwable {

        Map<String,Object>objectMap=new HashMap<>();
        HttpService httpService=method.getDeclaringClass().getAnnotation(HttpService.class);

        Http http = AnnotatedElementUtils.getMergedAnnotation(method, Http.class);
        if (http == null) {
            return proxy.invokeSuper(obj, args);
        }

        String url=httpService.baseUrl()+http.url();

        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; i++) {
            if (parameters[i].getAnnotation(Param.class)!=null){
                objectMap.put("param",args[i]);
            }
            if (parameters[i].getAnnotation(Body.class)!=null){
                objectMap.put("body",args[i]);
            }
            if (parameters[i].getAnnotation(PathParam.class)!=null){
                PathParam param=parameters[i].getAnnotation(PathParam.class);
                if (StringUtils.isNotBlank(param.value())){
                    url=url.replace("{"+param.value()+"}",args[i].toString());
                }
                else
                {
                    url=url.replace("{"+parameters[i].getName()+"}",args[i].toString());
                }
            }
        }


        HttpConnection httpConnection = HttpConnection.of(url, objectMap.getOrDefault("param", null));
        Header headers = AnnotatedElementUtils.getMergedAnnotation(method, Header.class);
        if (headers != null) {
            for (String header : headers.value()) {
                httpConnection.header(header);
            }
        }

        Get get = method.getAnnotation(Get.class);
        if (get != null) {
            return httpConnection.get();
        }
        Post post = method.getAnnotation(Post.class);
        if (post != null) {
            return httpConnection.contentType(post.contentType())
                    .post(objectMap.getOrDefault("body", null));
        }
        Delete delete = method.getAnnotation(Delete.class);
        if (delete != null) {
            return httpConnection.delete();
        }
        Put put = method.getAnnotation(Put.class);
        if (put != null) {
            return httpConnection.contentType(put.contentType())
                    .put(objectMap.getOrDefault("body", null));
        }
        Patch patch = method.getAnnotation(Patch.class);
        if (patch != null) {
            return httpConnection.contentType(patch.contentType())
                    .patch(objectMap.getOrDefault("body", null));
        }
        return proxy.invokeSuper(obj, args);
    }


}