package cn.xisoil.service.login.impl;



import cn.xisoil.config.token.JwtUtils;
import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.dto.login.EditUserRequest;
import cn.xisoil.data.dto.login.LoginDto;
import cn.xisoil.data.dto.login.LoginRequest;
import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.ResponseException;
import cn.xisoil.service.login.LoginPermissionUtils;
import cn.xisoil.service.login.LoginService;
import jakarta.transaction.Transactional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl implements LoginService {

    @Autowired
    private UserRepository userRepository;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private LoginPermissionUtils loginPermissionUtils;

    @Override
    @Transactional
    public R<LoginDto> userLogin(LoginRequest request) {
        LoginUser user=userRepository.findOneByAccount(request.getAccount()).orElseThrow(()->new ResponseException(403,"账号不存在"));
        userRepository.save(user);
        if (!new BCryptPasswordEncoder().matches(request.getPassword(), user.getPassword())){
            throw new ResponseException(403,"账号或密码错误");
        }
        String token=jwtUtils.jwt(user);
        LoginDto loginDto=new LoginDto();
        loginDto.setToken(token);
        loginDto.setUser(user);
        loginDto.setPermissions(loginPermissionUtils.structureByRoleId(user.getRoleId()));
        return R.<LoginDto>builder()
                .result(HTTPCODE.SUCCESS)
                .message("登录成功")
                .data(loginDto)
                .build();
    }

    @Override
    public R<LoginUser> getUserInfo() {
        LoginUser user= jwtUtils.getLoginUser();
        return R.<LoginUser>builder().success().message("获取成功").data(userRepository.findById(user.getId()).get()).build();
    }

    @Override
    public R<String> edit(EditUserRequest request) {
        LoginUser user=jwtUtils.getLoginUser();
        if (!user.getPassword().equals(request.getPassword())){
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            String encode = passwordEncoder.encode(request.getPassword()); //进行动态加盐加密
            request.setPassword(encode);
        }
        BeanUtils.copyProperties(request,user);
        userRepository.save(user);
        return R.<String>builder().success().message("修改成功").build();
    }



}
