package cn.xisoil.service.login.impl;

import cn.xisoil.dao.permission.PermissionRepository;
import cn.xisoil.dao.role.RoleRepository;
import cn.xisoil.data.pojo.permission.Permission;
import cn.xisoil.data.pojo.role.Role;
import cn.xisoil.exception.ResponseException;
import cn.xisoil.service.login.LoginPermissionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class LoginPermissionUtilsImpl implements LoginPermissionUtils {


    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    @PersistenceContext()
    EntityManager entityManager;

    @Override
    public List<Permission> structureByRoleId(String roleId) {
        Role role = roleRepository.findById(roleId).orElseThrow(()->new ResponseException(403,"账户已被取消授权！"));
        Session session = entityManager.unwrap(Session.class);

//        session.enableFilter("permissionChildren").setParameterList("ids",yueRole.getPermissionIds());
        Specification<Permission>specification=((root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate>predicates=new ArrayList<>();
            predicates.add(criteriaBuilder.or(
                    criteriaBuilder.and(
                            root.get("id").in(role.getPermissionIds()),
                            root.get("parentId").isNull()
                            ),
                    criteriaBuilder.and(
                            root.get("id").in(role.getPermissionIds()),
                            criteriaBuilder.not(root.get("parentId").in(role.getPermissionIds())),
                            root.get("parentId").isNotNull()
                    )
            ));
            criteriaQuery.orderBy( criteriaBuilder.asc(root.get("comparable")));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        });
        List<Permission>permissions=permissionRepository.findAll(specification);
//        session.disableFilter("permissionChildren");
        return permissions;
    }

}
