package cn.xisoil.service.datacheck;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.dao.permission.PermissionRepository;
import cn.xisoil.dao.role.RoleRepository;
import cn.xisoil.data.pojo.permission.Permission;
import cn.xisoil.data.pojo.role.Role;
import cn.xisoil.utils.SpringContextUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class PermissionCheckAutomationSystem {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired
    private SpringContextUtils springContextUtils;

    private  List<PermissionCheckAutomation> permissionCheckAutomations = new ArrayList<>();

    @Autowired
    public void setPermissionCheckAutomationMap(){
        permissionCheckAutomations=springContextUtils.getBeansForType(PermissionCheckAutomation.class);
    }

    void checkPermission() {
        logger.info("数据检查==>权限检查开始");
        permissionCheckAutomations.forEach(v -> {
            if (v.auto()){
                logger.info("权限检查==>{}", v.getName());
                Permission permission = permissionRepository.findTopByName(v.getName())
                        .orElse(new Permission(v.getName(),v.getUrl()));
                if (StringUtils.isNotBlank(v.getParent())) {
                    Permission parent = permissionRepository.findTopByName(v.getParent())
                            .orElse(new Permission(v.getParent(), v.getUrl()+"Admin", "apps-o"));
                    parent = permissionRepository.save(parent);
                    permission.setParentId(parent.getId());
                } else {
                    permission.setIco("apps-o");
                }
                permissionRepository.save(permission);
                logger.info("权限检查==>{} 成功",v.getName());
            }
        });
    }


    @Autowired
    private RoleRepository roleRepository;

    String checkRole() {
        List<String> permissionIds = permissionRepository.findAllId();

        Role role = roleRepository.findTopByIdNotNull().orElse(new Role("初始化角色"));
        role.setPermissionIds(permissionIds);
        role = roleRepository.save(role);
        logger.info("角色检查==>成功");
        return role.getId();
    }



}
