package cn.xisoil.model.service.single;

import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.result.R;
import cn.xisoil.model.service.model.ModelService;
import cn.xisoil.utils.GenericObject;
import cn.xisoil.utils.SpringContextUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

public class SingleDaoServiceImpl<T,V extends YueRepository<T,String>> extends GenericObject<T> {

    @Autowired
    private V repository;

    @Autowired
    private SpringContextUtils springContextUtils;

    @Autowired
    private ModelService modelService;

    public R<String> edit(T request) {
        T t=repository.findTopByIdNotNull().orElse(object());
        BeanUtils.copyProperties(request,t);
        repository.save(t);
        return R.<String>builder().success().message("修改成功").build();
    }

    public R<List<T>> list(){
        List<T>list=repository.findAll();
        return R.<List<T>>builder().success().message("获取成功").data(list).build();
    }

    public R<T> get() {
        T t=repository.findTopByIdNotNull().orElse(object());
        return R.<T>builder().success().data(t).message("获取成功").build();
    }





}
