package cn.xisoil.model.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.data.enums.ObjectType;
import cn.xisoil.data.result.R;
import cn.xisoil.model.data.ModelClass;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.model.service.model.ModelService;
import cn.xisoil.utils.GenericObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


public abstract class ModelController<T> extends GenericObject<T> implements PermissionCheckAutomation<T> {

    @Autowired
    private ModelService modelService;

    @GetMapping("/columns")
    public R<ModelClass> columns() {
        ModelClass yueModelClass= modelService.getModelClass(super.getGenericClass());
        yueModelClass.setType(ObjectType.LIST);
        List<ModelColumn>columns= modelService.getModelColumns(super.getGenericClass());
        Map<String,List<ModelColumn>>groups=columns.stream().collect(Collectors.groupingBy(ModelColumn::getGroup));
        yueModelClass.setColumns(columns);
        yueModelClass.setGroups(groups);
        return R.<ModelClass>builder().data(yueModelClass).success().message("获取成功").build();
    }


}
