package cn.xisoil.exception.advice;


import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.AuthException;
import cn.xisoil.exception.NormalException;
import cn.xisoil.exception.ResponseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import jakarta.servlet.http.HttpServletRequest;

@RestControllerAdvice
public class YueRestExceptionController {



    @ExceptionHandler(HttpMessageNotReadableException.class)
    public R<?> jsonParseError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(getStatus(request).value()).message(ex.getMessage()).build();
    }

    @ExceptionHandler(NormalException.class)
    public R<?> NormalError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(getStatus(request).value()).message(ex.getMessage()).build();
    }

    @ExceptionHandler(AuthException.class)
    public R<?> AuthError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(HTTPCODE.FORBIDDEN.getCode()).message(ex.getMessage()).build();

    }


    @ExceptionHandler(ResponseException.class)
    public R<?> ResponseError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(getStatus(request).value()).message(ex.getMessage()).build();
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer) request.getAttribute("jakarta.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf(statusCode);
    }


}
