package cn.xisoil.data.pojo.webbasic.font;

import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.annotation.model.CurdTrusteeShipObject;
import cn.xisoil.annotation.model.PermissionTrusteeShipObject;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.data.enums.ObjectType;
import jakarta.persistence.*;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@Entity(name = "WebFont")
@Table(name = "web_font")
@EntityListeners(AuditingEntityListener.class)
public class WebFont {

    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "字体名称",required = true)
    private String title;

    @CurdModel(value = "字体文件",type = ObjectColumnType.FILE,required = true)
    private String url;


    @CurdModel(value = "添加时间",add = false,editor = false)
    @CreatedDate
    private Date createTime;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }


    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
